// Amen
// muhahahahahaha

// [:   cyanpjhase
// blakee@rovoscape.com
//

#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <windows.h>
#include "../MachineInterface.h"
#include "../dsplib/dsplib.h"

#include "resource.h" // for zee dialogs


#pragma optimize ("awy", on)


//___________________________________________________________________
// 
// Parameters and gruelling machine paperwork starts here
//___________________________________________________________________

CMachineParameter const paraTempo = {
	pt_byte,
	"Loop Length",
	"Loop Length",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	16
};

CMachineParameter const paraTrigger = {
	pt_switch,
	"Loop (1 on\\reset, 0 off)",
	"Loop (1 on\\reset, 0 off)",
	-1,
	-1,
	SWITCH_NO,
	0,
	0
};

CMachineParameter const paraFTrigger = {
	pt_switch,
	"Filter Trigger",
	"Filter Trigger",
	-1,
	-1,
	SWITCH_NO,
	0,
	0
};

CMachineParameter const paraCutoff = {
	pt_byte,
	"F: Cutoff",
	"F: Cutoff",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	0x7F
};

CMachineParameter const paraResonance = {
	pt_byte,
	"F: Resonance",
	"F: Resonance",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	0x7F
};

CMachineParameter const paraEnvMod = {
	pt_byte,
	"F: EnvMod",
	"F: EnvMod",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	0x7F
};

CMachineParameter const paraDecay = {
	pt_byte,
	"F: Decay",
	"F: Decay",
	1,
	0xFE,
	0xFF,
	MPF_STATE,
	0x7F
};

CMachineParameter const paraFType = {
	pt_byte,
	"F: Type",
	"F: Type",
	0,
	4,
	0xFF,
	MPF_STATE,
	0
};


CMachineParameter const *pParameters[] = {
	&paraTrigger,
	&paraFTrigger,
	&paraTempo,
	&paraCutoff,
	&paraResonance,
	&paraEnvMod,
	&paraDecay,
	&paraFType
};

CMachineAttribute const *pAttributes[] = { NULL };


#pragma pack(1)

class gvals
{
public:
	byte trig;
	byte ftrig;
	byte tempo;

	byte cutoff;
	byte resonance;
	byte envmod;
	byte decay;
	byte ftype;
};

#pragma pack()

CMachineInfo const MacInfo =
{

	MT_GENERATOR,
	MI_VERSION,
	0,
	0,
	0,
	8,
	0,
	pParameters,
	0,
	pAttributes,
	"SuperDonut Ultimate Drum",
	"Amen",
	"Doughnuts and ReBirth",
	"about"
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Tick();
	virtual void Stop();

	virtual void Init(CMachineDataInput * const pi);
	virtual bool Work(float *psamples, int numsamples, int const mode);
	virtual char const *DescribeValue(int const param, int const value);

	virtual void Command(int const i);

	virtual void refilt();

public:
	CMachine *ThisMachine;

	int icnt;
	int out;
	double looplen;
	double loopn;
	gvals gval;

	float current_cutoff;
	float current_resonance;
	float envmod;
	float decay;
	int current_filter;

	float coefsTab1[5];
	float ax1,ay1,ax2,ay2;
	float bx1,by1,bx2,by2;

	float filtpoint;
	float lcutoff;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
}

mi::~mi() 
{
}

#include "amenshit.h"

void mi::refilt() {
	float omega, sn, cs, alpha;
	float a0, a1, a2, b0, b1, b2;

	if (lcutoff < 30.0f) { lcutoff = 30.0f; };
	if (lcutoff > 7000.0f) { lcutoff = 7000.0f; };
	switch (current_filter) {
	case 0:
		coefsTab1[0] = 1.0f; coefsTab1[1] = 0.0f; coefsTab1[2] = 0.0f;
		coefsTab1[3] = 0.0f; coefsTab1[4] = 0.0f;
		break;
	case 1: // LPx2
		omega = 2.0f * PI * lcutoff / (pMasterInfo->SamplesPerSec);
		sn = (float)sin ( omega); cs = (float)cos ( omega);
		alpha = sn / (current_resonance / 2.0f);
		b0 = (1.0f - cs) / 2.0f;
		b1 = 1.0f - cs;
		b2 = (1.0f - cs) / 2.0f;
		a0 = 1.0f + alpha;
		a1 = -2.0f * cs;
		a2 = 1.0f - alpha;
		coefsTab1[0] = b0/a0;
		coefsTab1[1] = b1/a0;
		coefsTab1[2] = b2/a0;
		coefsTab1[3] = -a1/a0;
		coefsTab1[4] = -a2/a0;
		break;
	case 2:// HPx2
		omega = 2.0f * PI * lcutoff / (pMasterInfo->SamplesPerSec);
		sn = (float)sin ( omega); cs = (float)cos ( omega);
		alpha = sn / (current_resonance / 2.0f);
		b0 = (1.0f + cs) / 2.0f;
		b1 = -(1.0f + cs);
		b2 = (1.0f + cs) / 2.0f;
		a0 = 1.0f + alpha;
		a1 = -2.0f * cs;
		a2 = 1.0f - alpha;
		coefsTab1[0] = b0/a0;
		coefsTab1[1] = b1/a0;
		coefsTab1[2] = b2/a0;
		coefsTab1[3] = -a1/a0;
		coefsTab1[4] = -a2/a0;
		break;
	case 3: // BPx2
		omega = 2.0f * PI * lcutoff / (pMasterInfo->SamplesPerSec);
		sn = (float)sin ( omega); cs = (float)cos ( omega);
		alpha = sn * sinh((current_resonance / 2.0) * omega / sn);
		b0 = alpha;
		b1 = 0.0f;
		b2 = -alpha;
		a0 = 1.0f + alpha;
		a1 = -2.0f * cs;
		a2 = 1.0f - alpha;
		coefsTab1[0] = b0/a0;
		coefsTab1[1] = b1/a0;
		coefsTab1[2] = b2/a0;
		coefsTab1[3] = -a1/a0;
		coefsTab1[4] = -a2/a0;
		break;
	case 4: // Notchx2
		omega = 2.0f * PI * lcutoff / (pMasterInfo->SamplesPerSec);
		sn = (float)sin ( omega); cs = (float)cos ( omega);
		alpha = sn * sinh( (current_resonance/8.0) * omega / sn);
		b0 = 1.0f;
		b1 = -2.0f * cs;
		b2 = 1.0f;
		a0 = 1.0f + alpha;
		a1 = -2.0f * cs;
		a2 = 1.0f - alpha;
		coefsTab1[0] = b0/a0;
		coefsTab1[1] = b1/a0;
		coefsTab1[2] = b2/a0;
		coefsTab1[3] = -a1/a0;
		coefsTab1[4] = -a2/a0;
		break;
	default:
		break;
	};
};


void mi::Init(CMachineDataInput * const pi)
{
	// Init code
	ThisMachine = pCB->GetThisMachine();
	loopn = 0.0;
	looplen = 16.0;
	out = 0;

	current_cutoff = 11000.0f;
	current_resonance = 13.0f;

	lcutoff = 11000.0f;
	icnt = 0;

	coefsTab1[0] = 0.0f;
	coefsTab1[1] = 0.0f;
	coefsTab1[2] = 0.0f;
	coefsTab1[3] = 0.0f;
	coefsTab1[4] = 0.0f;

	ax1=ay1=ax2=ay2 = 0.0f;
	bx1=by1=bx2=by2 = 0.0f;

	envmod = 0;
	decay = 0;

	filtpoint = 1.0f;

	// copy of mi::Tick here
	if (gval.tempo != 0xFF) { looplen = (double)gval.tempo; };
	if (gval.cutoff != 0xFF) current_cutoff = ((float)gval.cutoff / 254.0f * 8000.0f) + 20.0f;
	if (gval.resonance != 0xFF) current_resonance = ((float)gval.resonance / 254.0f * 25.0f) + 0.5f;
	if (gval.envmod != 0xFF) envmod = ((float)gval.envmod / 254.0f);
	if (gval.decay != 0xFF) decay = (float)((254-gval.decay)+1)/12800.0f;
	if (gval.ftype != 0xFF) current_filter = gval.ftype;
}

void mi::Tick()
{
	if (gval.tempo != 0xFF) { looplen = (double)gval.tempo; };
	if (gval.trig != SWITCH_NO) { 
		if (gval.trig == SWITCH_ON) {
			loopn = 0.0;
			out = 1;
		};
		if (gval.trig == SWITCH_OFF) {
			loopn = 0.0;
			out = 0;
		};
	}
	if (gval.ftrig != SWITCH_NO) { 
		if (gval.ftrig == SWITCH_ON) filtpoint = 0.0f;
	}
	if (gval.cutoff != 0xFF) current_cutoff = ((float)gval.cutoff / 254.0f * 8000.0f) + 20.0f;
	if (gval.resonance != 0xFF) current_resonance = ((float)gval.resonance / 254.0f * 25.0f) + 0.5f;
	if (gval.envmod != 0xFF) envmod = ((float)gval.envmod / 254.0f);
	if (gval.decay != 0xFF) decay = (float)((254-gval.decay)+1)/12800.0f;
	if (gval.ftype != 0xFF) current_filter = gval.ftype;
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{
	double const ad2i = (1.5 * (1 << 26) * (1 << 26));
	double magicres;
	float curfrac;
	int i, rVal;
	unsigned int ucursamp;
	float forout, xm1, x0, x1, x2, y;

	if (out == 0) return false;

	double speedstep = ((double)pMasterInfo->BeatsPerMin / 135.0) * ((double)pMasterInfo->TicksPerBeat / 4.0) * (16.0 / looplen);

	for (i = 0; i < numsamples; i++){

		// basic (CSI) resampler
		magicres = (loopn - 0.5) + ad2i;
		rVal =  *(int *)&magicres;
		ucursamp = (unsigned int)(rVal) + 1u;
		curfrac = (float)(loopn - (double)rVal);
		xm1 = (float)(amen[ucursamp - 1u]);
		x0 = (float)(amen[ucursamp]);
		x1 = (float)(amen[ucursamp + 1u]);
		x2 = (float)(amen[ucursamp + 2u]);
		forout = ((((3.0f * (x0 - x1) - xm1 + x2) * 0.5f * curfrac) + 2.0f * x1 + xm1 - (5.0f * x0 + x2) * 0.5f) * curfrac + (x1 - xm1) * 0.5f) * curfrac + x0;

		// Filter Shit (tm)

		icnt++;
		if (icnt > 100) {
			filtpoint = filtpoint + decay;
			if (filtpoint > 1.0f) { filtpoint = 1.0f; };
			lcutoff = current_cutoff + (envmod * current_cutoff) - (envmod * (current_cutoff * filtpoint));
			refilt();
			icnt = 0;
		}

		y = coefsTab1[0] * forout +
			coefsTab1[1] * ax1 +
			coefsTab1[2] * ax2 +
			coefsTab1[3] * ay1 +
			coefsTab1[4] * ay2;
		ay2 = ay1; ay1 = y; ax2 = ax1; ax1 = forout; forout = y;
		y = coefsTab1[0] * forout +
			coefsTab1[1] * bx1 +
			coefsTab1[2] * bx2 +
			coefsTab1[3] * by1 +
			coefsTab1[4] * by2;
		by2 = by1; by1 = y; bx2 = bx1; bx1 = forout; forout = y;

		// output
		*psamples++ = forout;

		// step shit
		loopn += speedstep;
		if (loopn > 78387.0f) loopn -= 78387.0f;
	}

	return true;
}

void mi::Stop()
{
	out = 0;
}

char const *mi::DescribeValue(int const param, int const value)
{
	static char txt[16];

	switch(param)
	{
	case 0:	// triggers
	case 1:
		return NULL;
		break;
		
	case 2:				
		sprintf(txt, "%i ticks", value);
		return txt;
		break;

	case 3:
	case 4:
	case 5:
	case 6:
		sprintf(txt, "%.1f%%", ((float)value / 2.54f));
		return txt;
		break;
	case 7:
		switch (value) {
		case 0: return ("none");
		case 1: return ("24dB LP");
		case 2: return ("24dB HP");
		case 3: return ("BP");
		case 4: return ("Notch");
		default: return NULL;
		}
	default: return NULL;
		break;
	};
}


HINSTANCE dllInstance;
mi *g_mi;

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH:
		dllInstance = (HINSTANCE) hModule;
		break;

	case DLL_THREAD_ATTACH:

		break;

	case DLL_THREAD_DETACH:
		break;

	case DLL_PROCESS_DETACH:
		
		break;
	}
	return TRUE;
}

BOOL APIENTRY AboutDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		char txt[10000];
		
		sprintf (txt, "[01:52] *** sine909 (~sine909@64.165.251.155) has joined #buzz");
		sprintf (txt, "%s\r\n[01:52] <sine909> you are all homo homo",txt);
		sprintf (txt, "%s\r\n[01:52] *** sine909 (~sine909@64.165.251.155) Quit (Client Quit)",txt);
		sprintf (txt, "%s\r\n___________________________________________________________________________",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n   Nick      #   Random Quote ",txt);
		sprintf (txt, "%s\r\n1  bignicca  378 \"clatter: that cant be helped. our whole society is based on resources.\"",txt);
		sprintf (txt, "%s\r\n2  canc3r    314 \"I think its mostly self explanatory\"  ",txt);
		sprintf (txt, "%s\r\n3  cyanpjh   251 \"almost shitiest on earth\"  ",txt);
		sprintf (txt, "%s\r\n4  setzer_   238 \"it 'twas a phat break\"  ",txt);
		sprintf (txt, "%s\r\n5  clatter   141 \"I had a Tandy Colour Computer in 1984 or 5\"  ",txt);
		sprintf (txt, "%s\r\n6  clarion   134 \"Maestro: i'm pretty nifty with networking\"  ",txt);
		sprintf (txt, "%s\r\n7  wiz|coala 131 \"the pop culture is doomed\"  ",txt);
		sprintf (txt, "%s\r\n8  Uksi      117 \"clarion, i went back to nyc for spring break, had tons of stuff to do...\"  ",txt);
		sprintf (txt, "%s\r\n9  djlaser   113 \"canc3r did you checked my last ep\"  ",txt);
		sprintf (txt, "%s\r\n10 Mute      76  \"my first computer was a 8086\"  ",txt);
		sprintf (txt, "%s\r\n11 djboo     72  \"i hope clatter likes it\"  ",txt);
		sprintf (txt, "%s\r\n12 fsm0      64  \"if it was bad, nobody would listen to it\"  ",txt);
		sprintf (txt, "%s\r\n13 Mva       59  \"Boo: how is the Vinyl going?\"  ",txt);
		sprintf (txt, "%s\r\n14 melo      58  \"wish i had a tape recorder or mic for that live show...\"  ",txt);
		sprintf (txt, "%s\r\n15 Bul       58  \"clarakow : say what??\"  ",txt);
		sprintf (txt, "%s\r\n16 MrE\\Bull  56  \"canc3er: Wanna hear sompthing from me ?\"  ",txt);
		sprintf (txt, "%s\r\n17 Belve     54  \"battery is really good\"  ",txt);
		sprintf (txt, "%s\r\n18 soul_man  51  \"im iam good buzz?? haha\"  ",txt);
		sprintf (txt, "%s\r\n19 klaraCow  50  \"CCS took over #audiowarez ? ;)\"  ",txt);
		sprintf (txt, "%s\r\n20 DocBexter 47  \"he said trackers are shit...\"  ",txt);
		sprintf (txt, "%s\r\n21 fhobia    45  \"minibuzz ?\"  ",txt);
		sprintf (txt, "%s\r\n22 MistahE   43  \"He bul what ya gonna do tonight\"  ",txt);
		sprintf (txt, "%s\r\n23 discharge 39  \"klaracow: are you done drilling oskari's holes?\"  ",txt);
		sprintf (txt, "%s\r\n24 boo-pso   37  \"i hopes u likes it :)\"  ",txt);
		sprintf (txt, "%s\r\n25 _phi      35  \"I'd rather go to quadra island and get really stoned\"  ",txt);
		sprintf (txt, "%s\r\n26 |BaRoN1|  33  \"can you recommend on a structure .... like\"  ",txt);
		sprintf (txt, "%s\r\n27 Socrates  28  \"so much work.... so little desire to do it\"  ",txt);
		sprintf (txt, "%s\r\n28 acid1     23  \"i must have talked for about an hour after that question\"  ",txt);
		sprintf (txt, "%s\r\n29 Vectrex   22  \"what's it for rather\"  ",txt);
		sprintf (txt, "%s\r\n30 techrush  22  \"you pig fucking little shit face\"  ",txt);
		sprintf (txt, "%s\r\n31 KarahaNa  22  \"so... where do i get this matlide tracker?\"  ",txt);
		sprintf (txt, "%s\r\n32 SevOPT    20  \"well i'm not makin friends with assholes\"  ",txt);
		sprintf (txt, "%s\r\n33 hwm       20  \"retards can marry & have sex if they aren't minors here now...\"  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nChanged  by  New topic ",txt);
		sprintf (txt, "%s\r\n_phi     \"<melo> can i have ops? i want to kick karahana\" ",txt);
		sprintf (txt, "%s\r\nclatter  \"<cyanpjh> ... highway of doom weather\" ",txt);
		sprintf (txt, "%s\r\nclatter  \"she'd get a mouthfull of man bloob\" ",txt);
		sprintf (txt, "%s\r\ncanc3r   \"<klaraCow> oh me stupid ass\" ",txt);
		sprintf (txt, "%s\r\ncyanpjh  \"*** oskari (oskari@dsl-hki2-153.dial.inet.fi) has joined #trax\" ",txt);
		sprintf (txt, "%s\r\nTotal number of topics during the reporting period: 10",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nBig Numbers",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nBelve    couldn't decide whether to stay or go and joined #buzz.20010324 7 times during this reporting period.. ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nclatter  really wanted others to know what was doing - 8 descriptions alltogether. ",txt);
		sprintf (txt, "%s\r\n   Sample:",txt);
		sprintf (txt, "%s\r\n   [12:36] * clatter wonders if he can DJ mix for 2 hours strait without fumbling a beat ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nKarahaNa didn't get it on the first time and got kicked out for 4 times... ",txt);
		sprintf (txt, "%s\r\n   Sample: ",txt);
		sprintf (txt, "%s\r\n   [13:11] <KarahaNa> all i asked is a simple question..... and u dumbass dont know how to answer it.... u call ur self an ... ",txt);
		sprintf (txt, "%s\r\n   [13:17] *** KarahaNa was kicked by melo (i love you)  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\ncanc3r   knew what to say and said \"Kick\" for 4 times. ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\ncyanpjh  gave most ops - actually 14 of them.  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nUksi     had many things uncertain - 21% of lines contained a question. ",txt);
		sprintf (txt, "%s\r\n   ..and silver medal goes to wiz|coala - with question ratio of 14%.  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nbignicca spoke most monologues - wrote over 5 lines in a row for 9 times..  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\nUksi     wrote longest lines - average of 43 letters per line. ",txt);
		sprintf (txt, "%s\r\n   Average line length on #buzz.20010324 was 28 letters.  ",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n.:[> > > 303.org/buzz/  ]:.",txt);
		sprintf (txt, "%s\r\n___________________________________________________________________________",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n<Jukashi> hey where can i get some samples for fruityloops? ",txt);
		sprintf (txt, "%s\r\n<+midisax> www'generalmills.com",txt);
		sprintf (txt, "%s\r\n<Jukashi> um",txt);
		sprintf (txt, "%s\r\n<Jukashi> no",txt);
		sprintf (txt, "%s\r\n<+midisax> oh thats lucky charms",txt);
		sprintf (txt, "%s\r\n<+midisax> www.kellogs.com",txt);
		sprintf (txt, "%s\r\n<amr0> yap",txt);
		sprintf (txt, "%s\r\n<Jukashi> :|",txt);
		sprintf (txt, "%s\r\n<+midisax> kelloggs",txt);
		sprintf (txt, "%s\r\n<+midisax> send 20 boxtops to:",txt);
		sprintf (txt, "%s\r\n<+midisax> fruityloops",txt);
		sprintf (txt, "%s\r\n<+midisax> 214623 CR 5 #4",txt);
		sprintf (txt, "%s\r\n<+midisax> battle creek",txt);
		sprintf (txt, "%s\r\n<+midisax> eeeek im being less than a help",txt);
		sprintf (txt, "%s\r\n___________________________________________________________________________",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n",txt);
		sprintf (txt, "%s\r\n.:[the super doughnutz are watching u]:.",txt);
		sprintf (txt, "%s\r\n",txt);
		SetDlgItemText(hDlg,IDC_EDIT1,txt);

		return 1;
	}
	case WM_SHOWWINDOW:
		return 1;
	case WM_CLOSE:
		EndDialog (hDlg, TRUE);

	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			EndDialog(hDlg, TRUE);
			return 1;
		default:
			return 0;
		}
		break;
	}
	return 0;
}


void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		g_mi=this;
		DialogBox(dllInstance, MAKEINTRESOURCE (IDD_AMENABOUT), GetForegroundWindow(), (DLGPROC) &AboutDialog);

		break;
	default:
		break;
	}
}
